<?php
/**
 * Template part for displaying Blog Section
 *
 * @package Business_One_Page_Pro
 */

$blog_title    = get_theme_mod( 'business_one_page_pro_blog_section_title' );
$blog_content  = get_theme_mod( 'business_one_page_pro_blog_section_content' );
$blog_view_all = get_theme_mod( 'business_one_page_pro_blog_section_view_all', __( 'View All Blogs', 'business-one-page-pro' ) );
$blog_char     = get_theme_mod( 'business_one_page_pro_blog_no_of_char', 125 );
$blog_page     = get_option( 'page_for_posts' );

if( $blog_page || $blog_title || $blog_content ){
?>

<section id="blog" class="blog-section">
    <div class="container">
    <?php
    if( $blog_title || $blog_content ){ ?>
        <header class="heading">
        	<h1><?php echo esc_html( $blog_title ); ?></h1>
        	<?php echo wpautop( wp_kses_post( $blog_content ) ); ?>
        </header>
    <?php 
    }
    
    if( $blog_page ){
        echo '<div class="blog-post-holder"><div class="row">';
        
        $cat = get_theme_mod( 'business_one_page_pro_exclude_categories' );
        if( $cat ) $cat = array_diff( array_unique( $cat ), array('') );
        
        $blog_qry = new WP_Query( array( 'posts_per_page' => 3, 'ignore_sticky_posts' => true, 'category__not_in' => $cat ) );
        if( $blog_qry->have_posts() ){
            while( $blog_qry->have_posts()  ){
                $blog_qry->the_post();
                ?>
                <div class="columns-3">
					<div class="post">
						<?php if( has_post_thumbnail() ){?>
                        <div class="img-holder">
							<a href="<?php the_permalink(); ?>" class="post-thumbnail">
                                <?php the_post_thumbnail( 'business-one-page-pro-blog' ); ?>
                            </a>
                            <?php business_one_page_pro_categories(); ?>
						</div>
                        <?php } ?>
						<header class="entry-header">
							<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
						</header>
						<div class="entry-content">
							<?php
                                if( has_excerpt() ){
                                    the_excerpt();
                                }else{ 
                                    echo wpautop( wp_kses_post( business_one_page_pro_excerpt( get_the_content(), $blog_char, '...' ) ) );
                                }
                            ?>
						</div>
						<div class="entry-meta">
							<?php business_one_page_pro_posted_on(); ?>                          
						</div>
					</div>
				</div>
                <?php                
            }
        }
        wp_reset_postdata();
        
        echo '</div>';
        if( $blog_view_all ) echo '<div class="btn-holder"><a href="' . esc_url( get_permalink( $blog_page ) ) . '">' . esc_html( $blog_view_all ) . '</a></div>';
        echo '</div>';
    }
    ?>
    </div>
</section>
<?php
}