<?php
/**
 * Template part for displaying About Section
 *
 * @package Business_One_Page_Pro
 */

$about_section_page = get_theme_mod( 'business_one_page_pro_about_section_page' );

if( $about_section_page || is_active_sidebar( 'about-section' ) ){
?>

<section id="about">
    <div class="container">
    <?php
        
        $about_qry = new WP_Query( array( 'page_id' => $about_section_page ) );
    
        if( $about_qry->have_posts() ){
            while( $about_qry->have_posts() ){
                $about_qry->the_post();
            ?>
                <header class="heading">
                	<?php 
                        the_title( '<h1>', '</h1>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( business_one_page_pro_excerpt( get_the_content(), 100, '...' ) );
                        } 
                    ?>
                </header>
            <?php            
            }
        }
        wp_reset_postdata();
    

        if( is_active_sidebar( 'about-section' ) ){ ?>
        <div class="three-cols">
        	<div class="row">
                <?php dynamic_sidebar( 'about-section' ); ?>
        	</div>
        </div>
        <?php
        }
        ?>
    </div>
</section>
<?php
}