<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Business_One_Page_Pro
 */

get_header(); ?>
   
	<section id="primary" class="content-area">
		
        <?php if ( have_posts() ) : ?>
        <p><?php _e( 'If you don&apos;t find what you want please do another search', 'business-one-page-pro' ); ?></p>
        
        <?php get_search_form(); ?>
                        
        <main id="main" class="site-main" role="main">

		<?php
			
            /* Start the Loop */
			while ( have_posts() ) : the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );

			endwhile;
            
            //pagination
			business_one_page_pro_pagination();

		else :

			get_template_part( 'template-parts/content', 'none' );

		?>
        
		</main><!-- #main -->
        
        <?php 
        endif;
        ?>
        
	</section><!-- #primary -->
            
<?php
get_sidebar();
get_footer();