<?php
/**
 * WP hooks used in this theme.
 *
 * @package Business_One_Page_Pro
 */

if( ! get_theme_mod( 'business_one_page_pro_ed_adminbar' ) ) add_filter( 'show_admin_bar', '__return_false' );

/**
 * Theme Initial Setup
 * @see business_one_page_pro_setup
 * @see business_one_page_pro_content_width
 * @see business_one_page_pro_theme_updater
*/
add_action( 'after_setup_theme', 'business_one_page_pro_setup' );
add_action( 'after_setup_theme', 'business_one_page_pro_content_width', 0 );
add_action( 'after_setup_theme', 'business_one_page_pro_theme_updater' );

/**
 * Enqueue Scripts
 * @see business_one_page_pro_scripts
*/
add_action( 'wp_enqueue_scripts', 'business_one_page_pro_scripts' );

/**
 * Enqueue Admin Scripts
 * @see business_one_page_pro_admin_scripts
*/
add_action( 'admin_enqueue_scripts', 'business_one_page_pro_admin_scripts' );

/**
 * Enqueue Customizer Control Script for displaying widget in respective panels
 * @see business_one_page_pro_customizer_js
*/
add_action( 'customize_controls_enqueue_scripts', 'business_one_page_pro_customizer_js' );

/**
 * Add class to body
 * @see business_one_page_pro_body_classes
*/
add_filter( 'body_class', 'business_one_page_pro_body_classes' );

/**
 * Move comment field to the bottm
 * @see business_one_page_pro_move_comment_field_to_bottom
*/
add_filter( 'comment_form_fields', 'business_one_page_pro_move_comment_field_to_bottom' );

/**
 * Dynamic CSS
 * @see business_one_page_pro_dynamic_css_cb
*/
add_action( 'wp_head', 'business_one_page_pro_dynamic_css_cb', 100 );

/**
 * Custom CSS
 * @see business_one_page_pro_custom_css
*/
add_action( 'wp_head', 'business_one_page_pro_custom_css', 101 );

/**
 * Custom JS
 * @see business_one_page_pro_custom_js
*/
add_action( 'wp_footer', 'business_one_page_pro_custom_js' );

/**
 * Enqueue Google Fonts 
 * @see business_one_page_pro_scripts_styles
*/
add_action( 'wp_enqueue_scripts', 'business_one_page_pro_scripts_styles' );

/**
 * Flush out the transients
 * @see business_one_page_pro_category_transient_flusher
 * @see business_one_page_pro_category_transient_flusher
*/
add_action( 'edit_category', 'business_one_page_pro_category_transient_flusher' );
add_action( 'save_post', 'business_one_page_pro_category_transient_flusher' );

/**
 * Remove default thumbnail and add custom thumbnail meta box.
 * @see business_one_page_pro_logo_metabox
 */
add_action( 'do_meta_boxes', 'business_one_page_pro_logo_metabox' );

/**
 * Add excerpt field in pages
 * @see business_one_page_pro_excerpts_in_pages
*/
add_action( 'init', 'business_one_page_pro_excerpts_in_pages' );

/**
 * Gooble Map for contact page templates
 * @see business_one_page_pro_google_map_cb
*/
add_action( 'wp_head', 'business_one_page_pro_google_map_cb' );

/**
 * Ajax Search
 * @see business_one_page_pro_ajax_search
*/
if( get_theme_mod( 'business_one_page_pro_ed_ajax_search' ) ) {
    add_action( 'wp_ajax_business_one_page_pro_search', 'business_one_page_pro_ajax_search' );
    add_action( 'wp_ajax_nopriv_business_one_page_pro_search', 'business_one_page_pro_ajax_search' );
}

/**
 * Add Post Class
 * @see business_one_page_pro_post_classes
*/
add_filter( 'post_class', 'business_one_page_pro_post_classes' );

/**
 * Excluding post from blog of specific categories
 * 
 * @see business_one_page_pro_exclude_cat
 * @see business_one_page_pro_custom_category_widget
 * @see business_one_page_pro_exclude_posts_from_recentPostWidget_by_cat
 */
add_filter( 'pre_get_posts', 'business_one_page_pro_exclude_cat' );

add_filter( "widget_categories_args", "business_one_page_pro_custom_category_widget" );

add_filter( "widget_categories_dropdown_args", "business_one_page_pro_custom_category_widget" );

add_filter( "widget_posts_args", "business_one_page_pro_exclude_posts_from_recentPostWidget_by_cat" );

/**
 * To allow Skype in Html attributes
 * @see business_one_page_pro_allowed_social_protocols 
 */
add_filter( 'kses_allowed_protocols' , 'business_one_page_pro_allowed_social_protocols' );

/** Remove issues with prefetching adding extra views */
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

/** Enable shortcodes in text widgets */
add_filter( 'widget_text', 'do_shortcode' );