<?php
/**
 * Icon Text Widget
 *
 * @package Business_One_Page_Pro
 */

// register Business_One_Page_Pro_Icon_Text_Widget widget
function business_one_page_pro_register_icon_text_widget(){
    register_widget( 'Business_One_Page_Pro_Icon_Text_Widget' );
}
add_action('widgets_init', 'business_one_page_pro_register_icon_text_widget');
 
 /**
 * Adds Business_One_Page_Pro_Icon_Text_Widget widget.
 */
class Business_One_Page_Pro_Icon_Text_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
			'business_one_page_pro_icon_text_widget', // Base ID
			__( 'RARA: Icon Text Widget', 'business-one-page-pro' ), // Name
			array( 'description' => __( 'An Icon Text Widget.', 'business-one-page-pro' ), ) // Args
		);
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? esc_url_raw( $instance['image'] ) : '';
        $style   = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        
        if( $image ){
            /** Added to work for demo content compatible */
            $path = parse_url( $image, PHP_URL_PATH );
            $segments = explode('/', rtrim($path, '/'));
            
            if( $segments[1] === 'preview' && $segments[2] === 'business-one-page-pro' ){
                $fimg_url = $image; /** If the img url has our demo url then simply return the url.*/
            }else{
                $attachment_id = business_one_page_pro_get_image_id( $image );
                $image_array   = wp_get_attachment_image_src( $attachment_id, 'full');
                $image      = preg_match('/(^.*\.jpg|jpeg|png|gif|ico*)/i', $image);
                $fimg_url      = $image_array[0]; 
            }
        }
        
        echo $args['before_widget']; ?>
        
        
            <div class="col <?php echo esc_attr( $style ); ?>">
				<?php if( $style == 'style3' ){?>
                <div class="table">
					<div class="table-row">
						<div class="table-cell">
				<?php } ?>
                            <?php if( $image ){ ?>
                                <div class="icon-holder">
                                    <img src="<?php echo esc_url( $fimg_url ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
                                </div>
                            <?php }elseif( $icon ){ ?>
                                <div class="icon-holder">
                                    <span class="fa <?php echo esc_attr( $icon ); ?>"></span>
                                </div>
                            <?php }?>
                
                            <div class="text-holder">
                            <?php 
                                if( $title ) {
                                    echo $args['before_title'] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args['after_title'];    
                                }
                                
                                if( $content ) echo wpautop( wp_kses_post( $content ) );
                            ?>								
							</div>
                            
                <?php if( $style == 'style3' ){?>    
						</div>
					</div>
				</div>
                <?php } ?>
			</div>
        <?php    
            
            
        
        echo $args['after_widget'];
    }

    /**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? esc_url_raw( $instance['image'] ) : '';
        $style   = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        
        ?>
		
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title', 'business-one-page-pro' ); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />            
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php esc_html_e( 'Content', 'business-one-page-pro' ); ?></label>
            <textarea name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php print $content; ?></textarea>
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_html_e( 'Select Style', 'business-one-page-pro' ); ?></label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" class="widefat">
				<option value="style1" <?php selected( 'style1', $style ) ?>><?php esc_html_e( 'Style 1', 'business-one-page-pro' ); ?></option>
				<option value="style2" <?php selected( 'style2', $style ) ?>><?php esc_html_e( 'Style 2', 'business-one-page-pro' ); ?></option>
				<option value="style3" <?php selected( 'style3', $style ) ?>><?php esc_html_e( 'Style 3', 'business-one-page-pro' ); ?></option>
				<option value="style4" <?php selected( 'style4', $style ) ?>><?php esc_html_e( 'Style 4', 'business-one-page-pro' ); ?></option>
			</select>
		</p>
        
        <?php business_one_page_pro_get_image_field( $this->get_field_id( 'image' ), $this->get_field_name( 'image' ), $image, __( 'Upload Image', 'business-one-page-pro' ) ); ?>
        
        <p><strong><?php esc_html_e( 'or', 'business-one-page-pro' ); ?></strong></p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'icon' ); ?>"><?php esc_html_e( 'Icons', 'business-one-page-pro' ); ?></label><br />
            <span class="icon-receiver"><i class="<?php echo esc_attr( $icon ); ?>"></i></span>
            <input class="hidden-icon-input" name="<?php echo $this->get_field_name( 'icon' ); ?>" type="hidden" id="<?php echo $this->get_field_id( 'icon' ); ?>" value="<?php echo esc_html( $icon ); ?>" />            
        </p>
        
        <?php business_one_page_pro_get_icon_list(); ?>
                        
        <?php
	}
    
    /**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
        $instance['title']   = ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '' ;
        $instance['content'] = ! empty( $new_instance['content'] ) ? $new_instance['content'] : '';
        $instance['style']   = ! empty( $new_instance['style'] ) ? $new_instance['style'] : 'style1';        
        $instance['image']   = ! empty( $new_instance['image'] ) ? esc_url_raw( $new_instance['image'] ) : '';
        $instance['icon']    = ! empty( $new_instance['icon'] ) ? $new_instance['icon'] : '';
        
        return $instance;
	}
    
}  // class Business_One_Page_Pro_Icon_Text_Widget 