<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Business_One_Page_Pro
 */

if( ! function_exists( 'business_one_page_pro_top_header' ) ) :
/**
 * Top Header
*/
function business_one_page_pro_top_header(){
    ?>
    <div class="top-header">
		<div class="container">
			
            <?php if( get_theme_mod( 'business_one_page_pro_ed_social_header' ) ) do_action( 'business_one_page_pro_social' ); ?>
            			
            <?php if( has_nav_menu( 'top' ) ) {?>
            <div id="mobile-header">
			    <a id="responsive-menu-button" href="#sidr-main"><?php esc_html_e( 'Menu', 'business-one-page-pro' ); ?></a>
			</div>
            
			<nav class="top-menu" id="topmenu">
				<?php wp_nav_menu( array( 'theme_location' => 'top', 'menu_id' => 'top-menu', 'fallback_cb' => false ) ); ?>
			</nav>
            <?php } ?>
            
		</div><!-- .container -->
	</div><!-- .top-header -->
    <?php
}
endif;

if( ! function_exists( 'business_one_page_pro_bottom_header' ) ) :
/**
 * Bottom Header
*/
function business_one_page_pro_bottom_header(){
    ?>
    <div class="header-b">
        <div class="container">
			
            <div class="site-branding">                    		
                <?php 
                    if( function_exists( 'has_custom_logo' ) && has_custom_logo() ){
                        the_custom_logo();
                    } 
                ?>		
       			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>                   		
                <?php
            		$description = get_bloginfo( 'description', 'display' );
            		if ( $description || is_customize_preview() ) : ?>
            			<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
        		<?php
      		        endif;
                ?>
        	</div><!-- .site-branding -->
            
            <!--<div id="nav-anchor"></div>-->
            <div id="mobile-header-primary">
			    <a id="responsive-menu-button-primary" href="#sidr-main-primary"><?php esc_html_e( 'Menu', 'business-one-page-pro' ); ?></a>
			</div>
			
            <?php 
                $enabled_sections = business_one_page_pro_get_sections();
                $ed_section_menu  = get_theme_mod( 'business_one_page_pro_ed_section_menu' );
                $home_link        = get_theme_mod( 'business_one_page_pro_ed_home_link' );
                
                if( $enabled_sections && ( 'page' == get_option( 'show_on_front' ) ) && ( $ed_section_menu != 1 ) ){ 
            ?>
                <nav id="site-navigation" class="main-navigation" role="navigation">
                    <ul>
                        <?php if( ! $home_link ){ ?>
                        <li class="<?php if( is_front_page() ) echo esc_attr( 'current-menu-item' ); ?>"><a href="<?php echo esc_url( home_url( '#home' ) ); ?>"><?php esc_html_e( 'Home', 'business-one-page-pro' ); ?></a></li>
                    <?php }
                        foreach( $enabled_sections as $section ){ 
                            if( $section['menu_text'] ){
                    ?>
                            <li><a href="<?php echo esc_url( home_url( '#' . esc_attr( $section['id'] ) ) ); ?>"><?php echo esc_html( $section['menu_text'] );?></a></li>                        
                    <?php 
                            } 
                        }
                    ?>
                    </ul>
                </nav>
            <?php }else{ ?>
                <nav id="site-navigation" class="main-navigation" role="navigation">
                    <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
                </nav><!-- #site-navigation -->
            <?php } ?>
            
        </div><!-- .container -->
    </div><!-- .header-b -->
    <?php    
}
endif;

if( ! function_exists( 'business_one_page_pro_social_cb' ) ) :
/**
 * Callback for Social Links  
*/
function business_one_page_pro_social_cb( $contact = false ){
    
    $social_ar = get_theme_mod( 'business_one_page_pro_social_contact', array( 'facebook', 'twitter', 'pinterest', 'linkedin', 'google-plus' ) );
    
    $social_icons = get_theme_mod( 'business_one_page_pro_social', array(
    		array(
    			'icon' => 'facebook',
    			'link' => 'https://facebook.com',
    		),
    		array(
    			'icon' => 'twitter',
    			'link' => 'https://twitter.com',
    		),
        ) );
        
    if( $contact ){
        $contact_icons = array();
        foreach( $social_ar as $s ){
            foreach( $social_icons as $i ){
                if( $s == $i['icon'] ){
                    array_push( $contact_icons, array( 'icon' => $i['icon'], 'link' => $i['link'] ) );
                }
            }
        }
        $socials = $contact_icons;            
    }else{
        $socials = $social_icons;
    }
    
    
    if( $socials ){ ?>
        <ul class="social-networks">
        <?php 
        foreach( $socials as $social ){
            if( $social['link'] ){ ?>
                <li><a href="<?php echo esc_url( $social['link'] ); ?>" <?php if( $social['icon'] != 'skype' ) echo 'target="_blank"'; ?> title="<?php echo esc_html( $social['icon'] ); ?>"><span class="fa fa-<?php echo esc_attr( $social['icon'] );?>"></span></a></li>
        <?php 
            } 
        } ?>
        </ul>
        <?php
    }
}
endif;

if( ! function_exists( 'business_one_page_pro_slider_cb' ) ) : 
/**
 * Callback for Home Page Slider 
*/
function business_one_page_pro_slider_cb(){
    
    $slider_caption    = get_theme_mod( 'business_one_page_pro_slider_caption', '1' );
    $slider_type       = get_theme_mod( 'business_one_page_pro_slider_type', 'post' ); 
    $slider_post_one   = get_theme_mod( 'business_one_page_pro_slider_post_one' );
    $slider_post_two   = get_theme_mod( 'business_one_page_pro_slider_post_two' );
    $slider_post_three = get_theme_mod( 'business_one_page_pro_slider_post_three' );
    $slider_post_four  = get_theme_mod( 'business_one_page_pro_slider_post_four' );
    $slider_post_five  = get_theme_mod( 'business_one_page_pro_slider_post_five' );
    $slider_cat        = get_theme_mod( 'business_one_page_pro_slider_cat' );
    $slider_slides     = get_theme_mod( 'business_one_page_pro_slider_slides' );
    $slider_readmore   = get_theme_mod( 'business_one_page_pro_slider_readmore', __( 'Learn More', 'business-one-page-pro' ) );
    $slider_full_img   = get_theme_mod( 'business_one_page_pro_slider_full_image' );
    
    $slider_posts      = array( $slider_post_one, $slider_post_two, $slider_post_three, $slider_post_four, $slider_post_five );
    $slider_posts      = array_diff( array_unique( $slider_posts ), array('') );
    
    if( $slider_full_img ){
        $img_size = 'full';
    }else{
        $img_size = 'business-one-page-pro-slider';
    }
            
    if( $slider_type == 'post' || $slider_type == 'cat' ){
        
        if( $slider_type == 'post' && $slider_posts ){
            $qry = new WP_Query ( array( 
                'post_type'           => array( 'post', 'page' ),
                'post_status'         => 'publish',
                'posts_per_page'      => -1,                    
                'post__in'            => $slider_posts, 
                'orderby'             => 'post__in',
                'ignore_sticky_posts' => true
            ) );
            
            if( $qry->have_posts() ){?>
                <div class="banner">
                    <div class="lightslider">
                        <ul id="banner-slider">
                        <?php
                        while( $qry->have_posts() ){
                            $qry->the_post();
                            $image = wp_get_attachment_image_src( get_post_thumbnail_id(), $img_size );
                        ?>
                            <?php if( has_post_thumbnail() ){?>
                            <li>
                                <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php the_title_attribute(); ?>" /></a>
                                <?php if( $slider_caption ){ ?>
            				    <div class="banner-text">
            						<div class="container">
            							<div class="text">
            								<span class="category"><?php business_one_page_pro_categories(); ?></span>
            								<strong class="title"><?php the_title(); ?></strong>
                                            <a class="btn-more" href="<?php the_permalink(); ?>"><?php echo esc_html( $slider_readmore );?></a>
            							</div>
            						</div>
            					</div>
                                <?php } ?>
                            </li>
                            <?php } ?>
                        <?php
                        }
                        ?>
                        </ul>
                    </div>
                </div>
                <?php
            }else{
                echo '<div class="banner"></div>';
            }
            wp_reset_postdata();       
        } //end of post slider
        
        if( $slider_type == 'cat' && $slider_cat ){
            $qry = new WP_Query ( array( 
                'post_type'           => 'post', 
                'post_status'         => 'publish',
                'posts_per_page'      => -1,                    
                'cat'                 => $slider_cat,
                'ignore_sticky_posts' => true
            ) );
            
            if( $qry->have_posts() ){?>
                <div class="banner">
                    <div class="lightslider">
                        <ul id="banner-slider">
                        <?php
                        while( $qry->have_posts() ){
                            $qry->the_post();
                            $image = wp_get_attachment_image_src( get_post_thumbnail_id(), $img_size );
                        ?>
                            <?php if( has_post_thumbnail() ){?>
                            <li>
                                <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php the_title_attribute(); ?>" /></a>
                                <?php if( $slider_caption ){ ?>
            				    <div class="banner-text">
            						<div class="container">
            							<div class="text">
            								<span class="category"><?php business_one_page_pro_categories(); ?></span>
            								<strong class="title"><?php the_title(); ?></strong>
                                            <a class="btn-more" href="<?php the_permalink(); ?>"><?php echo esc_html( $slider_readmore );?></a>
            							</div>
            						</div>
            					</div>
                                <?php } ?>
                            </li>
                            <?php } ?>
                        <?php
                        }
                        ?>
                        </ul>
                    </div>
                </div>
                <?php
            }else{
                echo '<div class="banner"></div>';
            }
            wp_reset_postdata();       
        }//end of cat slider   
        
    }elseif( $slider_type == 'custom' && $slider_slides ){ //end of post and cat slider ?>
        <div class="banner">
            <div class="lightslider">
                <ul id="banner-slider">
                <?php
                foreach( $slider_slides as $slides ){
                    if( $slides['thumbnail'] ){
                        $image = wp_get_attachment_image_src( $slides['thumbnail'], $img_size );
                        if( $image ){
                        ?>
                        <li>
                            <?php if( $slides['link'] ) echo '<a href="' . esc_url( $slides['link'] ) . '">'; ?>
                            <img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php esc_attr( $slides['title'] ); ?>" />
            				<?php if( $slides['link'] ) echo '</a>'; ?>
                            <?php if( $slider_caption && ( $slides['title'] || ( $slides['link'] && $slider_readmore ) ) ){ ?>
                            <div class="banner-text">
            					<div class="container">
                                    <div class="text">
                						<?php 
                                        if( $slides['title'] ) echo '<strong class="title">' . esc_html( $slides['title'] ) . '</strong>';
                						if( $slides['link'] && $slider_readmore ){ ?>
                                        <a href="<?php echo esc_url( $slides['link'] ); ?>" class="btn-more"><?php echo esc_html( $slider_readmore ); ?></a>
                                        <?php }?>
                					</div>
                                </div>
            				</div>
                            <?php }?>
                        </li>
                        <?php        
                        }        
                    }
                }
                ?>
                </ul>
            </div>
        </div>
        <?php
    }else{
        echo '<div class="banner"></div>';
    } // end of custom slider        
}
endif;

if( ! function_exists( 'business_one_page_pro_outer_wrapper_start' ) ) :
/**
 * Innerpage Div Open
*/
function business_one_page_pro_outer_wrapper_start(){
    if( ! is_page_template( 'templates/template-home.php' ) ) echo '<div class="inner-page">';
}
endif;

if( ! function_exists( 'business_one_page_pro_outer_wrapper_end' ) ) :
/**
 * Innerpage Div Close
*/
function business_one_page_pro_outer_wrapper_end(){
    if( ! is_page_template( 'templates/template-home.php' ) ) echo '</div>';
}
endif;

if( ! function_exists( 'business_one_page_pro_wrapper_start_cb' ) ) :
/**
 * Wrapper Start
*/
function business_one_page_pro_wrapper_start_cb(){
    if( ! is_page_template( array( 'templates/template-home.php', 'templates/template-about.php', 'templates/template-contact.php', 'templates/template-gallery.php', 'templates/template-portfolio.php', 'templates/template-services.php', 'templates/template-team.php', 'templates/template-testimonial.php' ) ) && ! is_404() ){?>
            <div id="content" class="site-content">
                <div class="container">
                    <div class="row">
                    <?php }
}
endif;

if( ! function_exists( 'business_one_page_pro_wrapper_end_cb') ) :
/**
 * Wrapper End
*/
function business_one_page_pro_wrapper_end_cb(){
    if( ! is_page_template( array( 'templates/template-home.php', 'templates/template-about.php', 'templates/template-contact.php', 'templates/template-gallery.php', 'templates/template-portfolio.php', 'templates/template-services.php', 'templates/template-team.php', 'templates/template-testimonial.php' ) ) && ! is_404() ){ ?>
                </div><!-- .row -->
            </div><!-- .container -->    
        </div><!-- #content -->
    <?php } 
}
endif;

if( ! function_exists( 'business_one_page_pro_top_section' ) ) :
/**
 * Top Section
*/
function business_one_page_pro_top_section(){
    if( ! is_page_template( 'templates/template-home.php' ) && ! ( is_front_page() && is_home() ) ){ 
    ?>
    <div class="top-section">
		<div class="container">
			<?php 
            /**
             * @hooked business_one_page_pro_page_header_cb
            */
            do_action( 'business_one_page_pro_page_header' );
            
            /**
             * @hooked business_one_page_pro_breadcrumbs_cb
            */
            if( get_theme_mod( 'business_one_page_pro_ed_breadcrumb' ) )
            do_action( 'business_one_page_pro_breadcrumbs' ) ;            
            ?>
		</div>
	</div>
    <?php
    }
}
endif;

if( ! function_exists( 'business_one_page_pro_page_header_cb' ) ) :
/**
 * Page Header
*/
function business_one_page_pro_page_header_cb(){
    global $post;
    echo '<div class="page-header"><h1 class="page-title">';
    if( is_home() && ! is_front_page() ){
        single_post_title();
    }
    
    if( is_singular() ){
        echo esc_html( $post->post_title );
    }
    
    if( is_archive() ){
        /** For Woocommerce */
        if( is_woocommerce_activated() && ( is_product_category() || is_product_tag() || is_shop() ) ){
            if( is_shop() ){
                if ( get_option( 'page_on_front' ) == wc_get_page_id( 'shop' ) ) {
            		return;
            	}
            	$_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';
            
            	if ( ! $_name ) {
            		$product_post_type = get_post_type_object( 'product' );
            		$_name = $product_post_type->labels->singular_name;
            	}
                echo esc_html( $_name );
            }elseif( is_product_category() || is_product_tag() ){
                $current_term = $GLOBALS['wp_query']->get_queried_object();
                echo esc_html( $current_term->name );
            }
        }else{
            the_archive_title(); //archive title    
        }
    }
    
    if( is_search() ){
        printf( esc_html__( 'Search Results for: %s', 'business-one-page-pro' ), '<span>' . get_search_query() . '</span>' );
    }
    
    if( is_404() ){
        esc_attr_e( 'Page Not Found', 'business-one-page-pro' );
    }
    echo '</h1></div>';
}
endif;

if( ! function_exists( 'business_one_page_pro_breadcrumbs_cb' ) ) : 
/**
 * Custom Bread Crumb
 *
 * @link http://www.qualitytuts.com/wordpress-custom-breadcrumbs-without-plugin/
 */
function business_one_page_pro_breadcrumbs_cb() {
 
  $showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
  $delimiter = get_theme_mod( 'business_one_page_pro_breadcrumb_separator', __( '/', 'business-one-page-pro' ) ); // delimiter between crumbs
  $home = get_theme_mod( 'business_one_page_pro_breadcrumb_home_text', __( 'Home', 'business-one-page-pro' ) ); // text for the 'Home' link
  $showCurrent = get_theme_mod( 'business_one_page_pro_ed_current', '1' ); // 1 - show current post/page title in breadcrumbs, 0 - don't show
  $before = '<span class="current">'; // tag before the current crumb
  $after = '</span>'; // tag after the current crumb
 
  global $post;
  $homeLink = home_url();
 
  if ( is_front_page() ) {
 
    if ( $showOnHome == 1 ) echo '<div id="crumbs"><a href="' . esc_url( $homeLink ) . '">' . esc_html( $home ) . '</a></div>';
 
  } else {
 
    echo '<div id="crumbs"><a href="' . esc_url( $homeLink ) . '">' . esc_html( $home ) . '</a> ' . esc_html( $delimiter ) . ' ';
    if( is_home() ){
      echo $before . single_post_title() . $after;  
            
    } elseif ( is_category() ) {
      $thisCat = get_category( get_query_var( 'cat' ), false );
      if ( $thisCat->parent != 0 ) echo get_category_parents( $thisCat->parent, TRUE, ' ' . esc_html( $delimiter ) . ' ' );
      echo $before .  esc_html( single_cat_title( '', false ) ) . $after;
 
    } elseif ( is_search() ) {
      echo $before . esc_html__( 'Search Results for "', 'business-one-page-pro' ) . esc_html( get_search_query() ) . esc_html__( '"', 'business-one-page-pro' ) . $after;
 
    } elseif ( is_day() ) {
      echo '<a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '">' . esc_html( get_the_time( 'Y' ) ) . '</a> ' . esc_html( $delimiter ) . ' ';
      echo '<a href="' . esc_url( get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) ) . '">' . esc_html( get_the_time( 'F' ) ) . '</a> ' . esc_html( $delimiter ) . ' ';
      echo $before . esc_html( get_the_time( 'd' ) ) . $after;
 
    } elseif ( is_month() ) {
      echo '<a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '">' . esc_html( get_the_time( 'Y' ) ) . '</a> ' . esc_html( $delimiter ) . ' ';
      echo $before . esc_html( get_the_time( 'F' ) ) . $after;
 
    } elseif ( is_year() ) {
      echo $before . esc_html( get_the_time( 'Y' ) ) . $after;
 
    } elseif ( is_single() && !is_attachment() ) {
    
      if ( is_woocommerce_activated() && 'product' === get_post_type() ) {
		if ( $terms = wc_get_product_terms( $post->ID, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {
			$main_term = apply_filters( 'woocommerce_breadcrumb_main_term', $terms[0], $terms );
			$ancestors = get_ancestors( $main_term->term_id, 'product_cat' );
            $ancestors = array_reverse( $ancestors );
    		foreach ( $ancestors as $ancestor ) {
    			$ancestor = get_term( $ancestor, 'product_cat' );    
    			if ( ! is_wp_error( $ancestor ) && $ancestor ) {
    				echo '<a href="' . esc_url( get_term_link( $ancestor ) ) . '">' . esc_html( $ancestor->name ) . '</a> ' . esc_html( $delimiter ) . ' ';
    			}
    		}
			echo '<a href="' . esc_url( get_term_link( $main_term ) ) . '">' . esc_html( $main_term->name ) . '</a>';
		}
        if ( $showCurrent == 1 ) echo ' ' . esc_html( $delimiter ) . ' ' . $before . esc_html( get_the_title() ) . $after;
      }elseif( get_post_type() === 'portfolio' ){
        $portfolio_page = get_theme_mod( 'business_one_page_pro_portfolio_section_page' );
        
        if( $portfolio_page ) {
            $page = get_post( $portfolio_page );
            echo '<a href="' . esc_url( get_the_permalink( $page->ID ) ) . '/">' . esc_html( $page->post_title ) . '</a>';
        }
        if( $portfolio_page && $showCurrent == 1 ) echo ' ' . esc_html( $delimiter ) . ' ';
         
        if ( $showCurrent == 1 ) echo $before . esc_html( get_the_title() ) . $after;
      }elseif ( get_post_type() != 'post' ) {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;        
        echo '<a href="' . esc_url( $homeLink . '/' . $slug['slug'] ) . '/">' . esc_html( $post_type->labels->singular_name ) . '</a>';
        if ( $showCurrent == 1 ) echo ' ' . esc_html( $delimiter ) . ' ' . $before . esc_html( get_the_title() ) . $after;
      } else {
        $cat = get_the_category(); 
        if( $cat ){
            $cat = $cat[0];
            $cats = get_category_parents( $cat, TRUE, ' ' . esc_html( $delimiter ) . ' ' );
            if ( $showCurrent == 0 ) $cats = preg_replace( "#^(.+)\s$delimiter\s$#", "$1", $cats );
            echo $cats;
        }
        if ( $showCurrent == 1 ) echo $before . esc_html( get_the_title() ) . $after;
      }
 
    } elseif( is_woocommerce_activated() && ( is_product_category() || is_product_tag() ) ){
        
        $current_term = $GLOBALS['wp_query']->get_queried_object();
        if( is_product_category() ){
            $ancestors = get_ancestors( $current_term->term_id, 'product_cat' );
            $ancestors = array_reverse( $ancestors );
    		foreach ( $ancestors as $ancestor ) {
    			$ancestor = get_term( $ancestor, 'product_cat' );    
    			if ( ! is_wp_error( $ancestor ) && $ancestor ) {
    				echo '<a href="' . esc_url( get_term_link( $ancestor ) ) . '">' . esc_html( $ancestor->name ) . '</a> ' . esc_html( $delimiter ) . ' ';
    			}
    		}
        }           
        if ( $showCurrent == 1 ) echo $before . esc_html( $current_term->name ) . $after;
        
    }elseif( is_woocommerce_activated() && is_shop() ){
        if ( get_option( 'page_on_front' ) == wc_get_page_id( 'shop' ) ) {
			return;
		}
		$_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

		if ( ! $_name ) {
			$product_post_type = get_post_type_object( 'product' );
			$_name = $product_post_type->labels->singular_name;
		}
        if ( $showCurrent == 1 ) echo $before . esc_html( $_name ) . $after;
        
    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $post_type = get_post_type_object(get_post_type());
      echo $before . esc_html( $post_type->labels->singular_name ) . $after;
 
    } elseif ( is_attachment() ) {
      $parent = get_post( $post->post_parent );
      $cat = get_the_category( $parent->ID ); 
      if( $cat ){
        $cat = $cat[0];
        echo get_category_parents( $cat, TRUE, ' ' . esc_html( $delimiter ) . ' ');
        echo '<a href="' . esc_url( get_permalink( $parent ) ) . '">' . esc_html( $parent->post_title ) . '</a>' . ' ' . esc_html( $delimiter ) . ' ';
      }
      if ( $showCurrent == 1 ) echo  $before . esc_html( get_the_title() ) . $after;
 
    } elseif ( is_page() && !$post->post_parent ) {
      if ( $showCurrent == 1 ) echo $before . esc_html( get_the_title() ) . $after;
 
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while( $parent_id ){
        $page = get_page( $parent_id );
        $breadcrumbs[] = '<a href="' . esc_url( get_permalink( $page->ID ) ) . '">' . esc_html( get_the_title( $page->ID ) ) . '</a>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse( $breadcrumbs );
      for ( $i = 0; $i < count( $breadcrumbs) ; $i++ ){
        echo $breadcrumbs[$i];
        if ( $i != count( $breadcrumbs ) - 1 ) echo ' ' . esc_html( $delimiter ) . ' ';
      }
      if ( $showCurrent == 1 ) echo ' ' . esc_html( $delimiter ) . ' ' . $before . esc_html( get_the_title() ) . $after;
 
    } elseif ( is_tag() ) {
      echo $before . esc_html( single_tag_title( '', false ) ) . $after;
 
    } elseif ( is_author() ) {
      global $author;
      $userdata = get_userdata( $author );
      echo $before . esc_html( $userdata->display_name ) . $after;
 
    } elseif ( is_404() ) {
      echo $before . esc_html__( 'Page Not Found', 'business-one-page-pro' ) . $after;
    } 
 
    echo '</div>';
 
  }
} // end business_one_page_pro_breadcrumbs_cb()
endif;

if( ! function_exists( 'business_one_page_pro_contact_details_cb' ) ) :
/**
 * Contact Details in Home page and Contact Page
*/
function business_one_page_pro_contact_details_cb( $section = false ){
    
    if( $section ){ // In Home page section
        $contact_info_title   = get_theme_mod( 'business_one_page_pro_contact_section_info_title' ) ; 
        $contact_info_content = get_theme_mod( 'business_one_page_pro_contact_section_info_content' );
        $contact_address      = get_theme_mod( 'business_one_page_pro_contact_section_address' );
        $contact_phone        = get_theme_mod( 'business_one_page_pro_contact_section_phone' );
        $contact_fax          = get_theme_mod( 'business_one_page_pro_contact_section_fax' );
        $contact_email        = get_theme_mod( 'business_one_page_pro_contact_section_email' );
    }else{ // In contact page
        $as_in_home           = get_theme_mod( 'business_one_page_pro_contact_asin_home_page', '1' );                
        $contact_info_title   = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_info_title' ) : get_theme_mod( 'business_one_page_pro_contact_detail_info_title' ); 
        $contact_info_content = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_info_content' ) : get_theme_mod( 'business_one_page_pro_contact_detail_info_content' );
        $contact_address      = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_address' ) : get_theme_mod( 'business_one_page_pro_contact_detail_address' );
        $contact_phone        = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_phone' ) : get_theme_mod( 'business_one_page_pro_contact_detail_phone' );
        $contact_fax          = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_fax' ) : get_theme_mod( 'business_one_page_pro_contact_detail_fax' );
        $contact_email        = $as_in_home ? get_theme_mod( 'business_one_page_pro_contact_section_email' ) : get_theme_mod( 'business_one_page_pro_contact_detail_email' );
    }
                    
    if( $contact_info_title ) echo '<h2>' . esc_html( $contact_info_title ) . '</h2>';
    if( $contact_info_content ) echo wpautop( wp_kses_post( $contact_info_content ) );
    if( $contact_address || $contact_phone || $contact_fax || $contact_email ){
    ?>            
    <ul class="contact-info-lists">
		<?php
            if( $contact_address ) echo '<li class="address"><address>' . wpautop( $contact_address ) . '</address></li>';
            if( $contact_phone ) echo '<li class="phone">' . esc_html( $contact_phone ) . '</li>';
            if( $contact_fax ) echo '<li class="fax">' . esc_html( $contact_fax ) . '</li>';
            if( $contact_email ) echo '<li class="email"><a href="mailto:' . esc_attr( $contact_email ) . '">' . esc_html( $contact_email ) . '</a></li>';
        ?>
	</ul>
    <?php 
    }
    
    if( get_theme_mod( 'business_one_page_pro_ed_social_contact' ) ) do_action( 'business_one_page_pro_social', true );
}
endif;

if( ! function_exists( 'business_one_page_pro_footer_credit' ) ) :
/**
 * Footer Credits 
*/
function business_one_page_pro_footer_credit(){
    $footer_copyright = get_theme_mod( 'business_one_page_pro_footer_copyright' );
    $ed_author_link   = get_theme_mod( 'business_one_page_pro_ed_author_link' );
    $ed_wp_link       = get_theme_mod( 'business_one_page_pro_ed_wp_link' );
    
    $text  = '<div class="site-info">';
    
    if( $footer_copyright ){
        $text .= wp_kses_post( $footer_copyright );
    }else{
        $text .=  esc_html__( 'Copyright &copy; ', 'business-one-page-pro' ) . date('Y'); 
        $text .= ' <a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a>. ';
    }
    
    if( ! $ed_author_link ){
        $text .= '<a href="' . esc_url( 'http://raratheme.com/wordpress-themes/business-one-page-pro/' ) .'" rel="author" target="_blank">' . esc_html__( 'Business One Page Pro by: Rara Theme', 'business-one-page-pro' ) .'</a> ';
    }
    
    if( ! $ed_wp_link ){
        $text .= sprintf( esc_html__( 'Powered by: %s', 'business-one-page-pro' ), '<a href="'. esc_url( __( 'https://wordpress.org/', 'business-one-page-pro' ) ) .'" target="_blank">WordPress</a>' );
    }
    
    $text .= '</div>';
    
    echo apply_filters( 'business_one_page_pro_footer_text', $text );    
}
endif;

if( ! function_exists( 'business_one_page_pro_fb_page_box_cb' ) ) :
/**
 * Callback to add Facebook Page Plugin JS
*/
function business_one_page_pro_fb_page_box_cb(){
    if( is_active_widget( false, false, 'business_one_page_pro_facebook_page_widget' ) ){ ?>
        <div id="fb-root"></div>
        <script>(function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) return;
        js = d.createElement(s); js.id = id;
        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.4";
        fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));</script>
    <?php }
}
endif;