<?php
/**
 * Customizer Social Section 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_social( $wp_customize ) {

    Kirki::add_section( 'business_one_page_pro_social_settings', array(
        'title'      => __( 'Social Settings', 'business-one-page-pro' ),
        'priority'   => 32,
        'capability' => 'edit_theme_options',
    ) );
    
    /** Enable/Disable Social in Header */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_social_header',
        'label'       => __( 'Enable Social Links in Header', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_social_settings',
        'default'     => '',
    ) );
    
    /** Enable/Disable Social in Contact Section */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_social_contact',
        'label'       => __( 'Enable Social Links in Contact Section', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_social_settings',
        'default'     => '',
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Social Icons in Contact Section', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_social_settings',
        'settings'  => 'business_one_page_pro_social_contact',
        'help'      => __( 'You can rearrange the order you want.', 'business-one-page-pro' ),
        'type'      => 'select',
        'multiple'    => 5,
        'default'   => array( 'facebook', 'twitter', 'pinterest', 'linkedin', 'google-plus' ),
        'choices'   => business_one_page_pro_social_icons()
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'repeater',
        'settings'    => 'business_one_page_pro_social',
        'label'       => __( 'Add Social Links', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_social_settings',
        'default'     => array(
    		array(
    			'icon' => 'facebook',
    			'link' => 'https://facebook.com',
    		),
    		array(
    			'icon' => 'twitter',
    			'link' => 'https://twitter.com',
    		),
        ),
        'fields'     => array(
            'icon'     => array(
                'type'     => 'select',
                'label'    => __( 'Social Icon', 'business-one-page-pro' ),
                'choices'  => business_one_page_pro_social_icons(),
                'default'  => 'dribbble'
            ),
            'link'     => array(
                'type'  => 'text',
                'label' => __( 'Link', 'business-one-page-pro' ),
                'description'  => __( 'Leave blank if you do not want to show.', 'business-one-page-pro' ),
            )
        ),
        'row_label' => array(
            'type' => 'field',
            'value' => __( 'link', 'business-one-page-pro' ),
            'field' => 'icon'
        ),        
    ) );
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_social' );    