<?php
/**
 * Customizer Sidebar Section 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_sidebar( $wp_customize ) {
    
    Kirki::add_section( 'business_one_page_pro_sidebar_settings', array(
        'title'       => __( 'Sidebar Settings', 'business-one-page-pro' ),
        'priority'    => 31,
        'capability'  => 'edit_theme_options',
        'description' => __( 'Add custom sidebars. You need to save the changes and reload the customizer to use the sidebars in the dropdowns below.
You can add content to the sidebars in Appearance / Widgets.', 'business-one-page-pro' ),
    ) );
    
    /** Custom Sidebars */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'repeater',
        'settings'    => 'business_one_page_pro_sidebar',
        'label'       => __( 'Add Sidebars', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => '',
        'fields'     => array(
            'name'     => array(
                'type'  => 'text',
                'label' => __( 'Name', 'business-one-page-pro' ),
                'description'  => __( 'Example: Homepage Sidebar', 'business-one-page-pro' ),
            ),
            'id'     => array(
                'type'  => 'text',
                'label' => __( 'ID', 'business-one-page-pro' ),
                'description'  => __( 'Enter a unique ID for the sidebar. Use only alphanumeric characters, underscores (_) and dashes (-), eg. "sidebar-home"', 'business-one-page-pro' ),
            )
        ),
        'row_label' => array(
            'type' => 'field',
            'value' => __( 'sidebar', 'business-one-page-pro' ),
            'field' => 'name'
        ),        
    ) );
    
    /** Blog Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_blog_page_sidebar',
        'label'       => __( 'Blog Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the blog page.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true ),
    ) );
    
    /** Single Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_single_page_sidebar',
        'label'       => __( 'Single Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the single pages. If a page has a custom sidebar set, it will override this.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true ),
    ) );
    
    /** Single Post */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_single_post_sidebar',
        'label'       => __( 'Single Post Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the single posts. If a post has a custom sidebar set, it will override this.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true ),
    ) );
    
    /** Archive Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_archive_page_sidebar',
        'label'       => __( 'Archive Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the archives. Specific archive sidebars will override this setting (see below).', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true ),
    ) );
    
    /** Category Archive Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_cat_archive_page_sidebar',
        'label'       => __( 'Category Archive Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the category archives.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'default-sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true, true ),
    ) );
    
    /** Tag Archive Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_tag_archive_page_sidebar',
        'label'       => __( 'Tag Archive Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the tag archives.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'default-sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true, true ),
    ) );
    
    /** Date Archive Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_date_archive_page_sidebar',
        'label'       => __( 'Date Archive Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the date archives.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'default-sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true, true ),
    ) );
    
    /** Author Archive Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_author_archive_page_sidebar',
        'label'       => __( 'Author Archive Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the author archives.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'default-sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true, true ),
    ) );
    
    /** Search Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_search_page_sidebar',
        'label'       => __( 'Search Page Sidebar', 'business-one-page-pro' ),
        'help'        => __( 'Select a sidebar for the search results.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sidebar_settings',
        'default'     => 'sidebar',
        'choices'     => business_one_page_pro_get_dynamnic_sidebar( true, true ),
    ) );
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_sidebar' );