<?php
/**
 * Customizer BreadCrumb Section 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_breadcrumb( $wp_customize ) {
    
    Kirki::add_section( 'business_one_page_pro_breadcrumb_settings', array(
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'title'      => __( 'BreadCrumb Settings', 'business-one-page-pro' ),
    ) );
    
    /** Enable/Disable BreadCrumb */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Enable Breadcrumb', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_breadcrumb_settings',
        'settings'  => 'business_one_page_pro_ed_breadcrumb',
        'type'      => 'toggle',
        'default'   => '',
    ) );
    
    /** Show/Hide Current */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Show Current', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_breadcrumb_settings',
        'settings'  => 'business_one_page_pro_ed_current',
        'type'      => 'toggle',
        'default'   => '1',
    ) );
    
    /** Home Text */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Breadcrumb Home Text', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_breadcrumb_settings',
        'settings'  => 'business_one_page_pro_breadcrumb_home_text',
        'type'      => 'text',
        'default'   => __( 'Home', 'business-one-page-pro' ),
    ) );
    
    /** Breadcrumb Separator */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Breadcrumb Separator', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_breadcrumb_settings',
        'settings'  => 'business_one_page_pro_breadcrumb_separator',
        'type'      => 'text',
        'default'   => __( '/', 'business-one-page-pro' ),
        'sanitize_callback' => 'business_one_page_pro_sanitize_text',
    ) );
       
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_breadcrumb' );