<?php
/**
 * Sanitaztion Functions 
*/

function business_one_page_pro_sanitize_text( $text ){
    return wp_kses_post( $text );
}

function business_one_page_pro_sanitize_email( $email, $setting ){
    // Sanitize $input as a hex value without the hash prefix.
	$email = sanitize_email( $email );    	
	// If $email is a valid email, return it; otherwise, return the default.
	return ( !empty( $email ) ? $email : $setting->default );    
}

function business_one_page_pro_sanitize_iframe( $iframe ){
    $allow_tag = array(
                    'iframe'=>array(
                        'src'=>array(),
                        'width'=>array(),
                        'height'=>array()
                    )
                );
    return wp_kses( $iframe, $allow_tag );
}

/**
 * Sanitize funtion for link in repeater field
*/
function business_one_page_pro_sanitize_customizer( $value ) {

    if ( !is_array( $value ) ) {
        $value = array();
    }
    
    /** For slider url */
    foreach ( $value['business_one_page_pro_slider_slides'] as $key => $subvalue ) {

        if ( isset( $value['business_one_page_pro_slider_slides'][ $key ]['link'] ) ) {
            $value['business_one_page_pro_slider_slides'][ $key ]['link'] = esc_url_raw( $value['business_one_page_pro_slider_slides'][ $key ]['link'] );
        }

    }
    
    /** For Social links */
    foreach ( $value['business_one_page_pro_social'] as $key => $subvalue ) {

        if ( isset( $value['business_one_page_pro_social'][ $key ]['link'] ) ) {
            $value['business_one_page_pro_social'][ $key ]['link'] = esc_url_raw( $value['business_one_page_pro_social'][ $key ]['link'] );
        }

    }
    
    /** For sidebar id */
    foreach ( $value['business_one_page_pro_sidebar'] as $key => $subvalue ) {

        if ( isset( $value['business_one_page_pro_sidebar'][ $key ]['id'] ) ) {
            $value['business_one_page_pro_sidebar'][ $key ]['id'] = sanitize_title( $value['business_one_page_pro_sidebar'][ $key ]['id'] );
        }

    }

    return $value;

}
add_action( 'sanitize_option_theme_mods_business-one-page-pro', 'business_one_page_pro_sanitize_customizer' );