<?php
/**
 * Customizer Service Page Template Panel 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_service( $wp_customize ) {
    
    Kirki::add_panel( 'business_one_page_pro_service_page_settings', array(
        'priority' => 25,
        'capability' => 'edit_theme_options',
        'title' => __( 'Service Page Settings', 'business-one-page-pro' ),
        'description' => __( 'Customize Service Page Settings', 'business-one-page-pro' ),
    ) );
    
    /** iFrame Section */
    Kirki::add_section( 'business_one_page_pro_iframe_section', array(
        'title' => __( 'iFrame Section', 'business-one-page-pro' ),
        'priority' => 21,
        'panel' => 'business_one_page_pro_service_page_settings',
    ) );
    
    /** Video Iframe */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_service_iframe',
        'label'       => __( 'Video Iframe', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_iframe_section',
        'default'     => '',
        'sanitize_callback' => 'business_one_page_pro_sanitize_iframe'
    ) );
    
    /** Feature Section */
    Kirki::add_section( 'business_one_page_pro_feature_section', array(
        'title' => __( 'Feature Section', 'business-one-page-pro' ),
        'priority' => 22,
        'panel' => 'business_one_page_pro_service_page_settings',
    ) );
    
    /** Feature Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_feature_title',
        'label'       => __( 'Feature Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_feature_section',
        'default'     => '',
    ) );
    
    /** Feature Section Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'editor',
        'settings'    => 'business_one_page_pro_feature_content',
        'label'       => __( 'Feature Section Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_feature_section',
        'default'     => '',
    ) );
    
    /** More Info Section */
    Kirki::add_section( 'business_one_page_pro_moreinfo_section', array(
        'title' => __( 'More Info Section', 'business-one-page-pro' ),
        'priority' => 25,
        'panel' => 'business_one_page_pro_service_page_settings',
    ) );
    
    /** More Info Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_moreinfo_title',
        'label'       => __( 'More Info Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_moreinfo_section',
        'default'     => '',
    ) );
    
    /** More Info Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'editor',
        'settings'    => 'business_one_page_pro_moreinfo_content',
        'label'       => __( 'More Info Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_moreinfo_section',
        'default'     => '',
    ) );
    
    /** Sort Service Page Section */
    Kirki::add_section( 'business_one_page_pro_sort_service_section', array(
        'title' => __( 'Sort Service Page Section', 'business-one-page-pro' ),
        'priority' => 25,
        'panel' => 'business_one_page_pro_service_page_settings',
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'sortable',
        'settings'    => 'business_one_page_pro_sort_servicepage',
        'label'       => __( 'Sort Sections', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sort_service_section',
        'default'     => '',
        'choices'     => array(
    		'intro'   => esc_attr__( 'Intro Section', 'business-one-page-pro' ),
    		'iframe'  => esc_attr__( 'iFrame Section', 'business-one-page-pro' ),
    		'feature' => esc_attr__( 'Feature Section', 'business-one-page-pro' ),
    		'cta'     => esc_attr__( 'Call to Action Section', 'business-one-page-pro' ),
    		'more'    => esc_attr__( 'More Info Section', 'business-one-page-pro' ),
            
    	),        
    ) );
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_service' );