<?php
/**
 * Rara Theme custom post and taxonomy definitions.
 *
 * @link https://codex.wordpress.org/Function_Reference/register_post_type
 * @link https://codex.wordpress.org/Function_Reference/register_taxonomy
 *
 * @package Rara_Theme
 */
 
// include the custom post type class
require_once( 'CPT.php' );

/**
 * Register a home post type.
 */

/**
 *  Client Logo Post Type
*/
$labels = array(        
    'post_type_name' => 'clients-logo',
    'singular'       => 'Clients Logo',
    'plural'         => 'Clients Logos',
    'slug'           => 'clients-logo'
);
$args = array(
    'labels'              => $labels,        
    'public'              => true,
    'exclude_from_search' => true,
    'menu_position'       => 5,
    'supports'            => array( 'title', 'thumbnail' ),
    'has_archive'         => false, 
    'menu_icon'           => 'dashicons-images-alt2',
);

$logo = new CPT( 'logo', $args );

$logo->set_textdomain( 'business-one-page-pro' ); // Setting text domain.

/**
 * Portfolio Post Type
*/
$labels = array(
    'post_type_name' => 'portfolio',
    'singular'       => 'Portfolio',
    'plural'         => 'Portfolios',
    'slug'           => 'portfolio'
);
$args = array(
		'description'        => __( 'Portfolio Custom Post Type.', 'business-one-page-pro' ),
		'public'             => true,
		'has_archive'        => false,
		'menu_position'      => 5,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
        'menu_icon'          => 'dashicons-portfolio'
	);

$portfolio = new CPT( $labels, $args ); // Registering Post Type

$portfolio->set_textdomain( 'business-one-page-pro' ); // Setting text domain.

/**
 * taxonomy, portfolio category for the post type "portfolio"
 */
$labels = array(
	'plural'        => 'Portfolio Categories',
	'singular'      => 'Portfolio Category',
	'taxonomy_name' => 'portfolio-category',
	'slug'          => 'portfolio-category',
);

$args = array(
	'hierarchical'      => true,
);

$portfolio->register_taxonomy( $labels, $args ); // Registering Taxonomy

/**
 * Testimonail Post Types
*/
$labels = array(
    'post_type_name' => 'testimonial',
    'singular'       => 'Testimonial',
    'plural'         => 'Testimonials',
    'slug'           => 'testimonial'
);
$args = array(
    'public'        => true,
    'menu_position' => 10,
    'supports'      => array( 'title', 'editor', 'thumbnail'),
    'has_archive'   => false,
    'menu_icon'     => 'dashicons-testimonial'
);
// create a Testimonial custom post type
$testimonial = new CPT( $labels, $args );
// text-domain
$testimonial->set_textdomain( 'business-one-page-pro' );

/**
 * Team Post Types 
*/
$labels = array(
    'post_type_name' => 'team',
    'singular'       => 'Team',
    'plural'         => 'Teams',
    'slug'           => 'team'
);
$args = array(
        'public'        => true,
        'menu_position' => 10,
        'supports'      => array( 'title', 'editor', 'thumbnail'),
        'has_archive'   => false,
        'menu_icon'    => 'dashicons-groups'
    );
// create a Team custom post type
$team = new CPT( $labels, $args );
// text-domain
$team->set_textdomain( 'business-one-page-pro' );