<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_One_Page_Pro
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
/**
 * @hooked business_one_page_pro_fb_page_box_cb
*/
do_action( 'business_one_page_pro_fb_page_box' );
?>
    <div id="page" class="site">
	
        <?php if( is_front_page() ) echo '<div id="home">'; ?>        
            <header id="masthead" class="site-header" role="banner">
        	
                <?php
                /**
                 * Functions hooked into business_one_page_pro_header action
                 * 
                 * @hooked business_one_page_pro_top_header     - 10
                 * @hooked business_one_page_pro_bottom_header  - 20
                */
                
                do_action( 'business_one_page_pro_header' );
                ?>
            </header><!-- #masthead -->
        
            <?php 
                /**
                 * Function hooked into business_one_page_pro_slider action
                 * 
                 * @hooked business_one_page_pro_slider_cb
                */
                if( is_front_page() ){                 
                    if( get_theme_mod( 'business_one_page_pro_ed_slider' ) ){ 
                        do_action( 'business_one_page_pro_slider' );
                    }else{
                        echo '<div class="banner"></div>';
                    }
                } 
            ?>        
        <?php if( is_front_page() ) echo '</div>'; ?><!-- #home -->
    
        <?php
        /**
         * Function hooked into business_one_page_pro_wrapper_start action
         * 
         * @hooked business_one_page_pro_outer_wrapper_start    - 10
         * @hooked business_one_page_pro_top_section            - 20
         * @hooked business_one_page_pro_wrapper_start_cb       - 30
        */
        do_action( 'business_one_page_pro_wrapper_start' );