<?php
/**
 * Business One Page Pro functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Business_One_Page_Pro
 */

/**
 * Custom template functions for this theme.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom template hooks for this theme.
 */
require get_template_directory() . '/inc/template-hooks.php';

/**
 * WP hooks used in this theme.
 */
require get_template_directory() . '/inc/wp-hooks.php';

/**
 * Custom functions for this theme.
 */
require get_template_directory() . '/inc/custom-functions.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
* If Kirki is not already installed, use the included version
*/
if ( ! class_exists( 'Kirki' ) ) {    
    require get_template_directory() . '/inc/kirki/kirki.php';
}

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Custom Post 
 */
require get_template_directory() . '/inc/cpt/custom-post.php';

/**
 * Post Meta Box
 */
require get_template_directory() . '/inc/cpt/metabox.php';

/**
 * Widgets
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Shortcodes
*/
require get_template_directory() . '/inc/shortcodes.php';

/**
 * WooCommerce
*/
require get_template_directory() . '/inc/woocommerce-functions.php';

/**
 * Typography Functions
*/
require get_template_directory() . '/inc/typography-functions.php';

/**
 * Dynamic Styles
*/
require get_template_directory() . '/css/style.php';

/**
 * Customizer Class for Import Demo
 */
require get_template_directory() . '/inc/customizer/custom-class.php';
require get_template_directory() . '/inc/import/ed-importer.php';