<?php
/**
 * Dynamic Styles
 *
 * @package business_one_page_pro
 */

function business_one_page_pro_dynamic_css_cb(){
    
    $body_font      = get_theme_mod( 'business_one_page_pro_body_font', array('font-family'=>'Source Sans Pro', 'variant'=>'regular') );    
    $body_fonts     = business_one_page_pro_get_fonts( $body_font['font-family'], $body_font['variant'] );
    $body_font_size = get_theme_mod( 'business_one_page_pro_body_font_size', '17' );
    $body_line_ht   = get_theme_mod( 'business_one_page_pro_body_line_height', '26' );
    $body_color     = get_theme_mod( 'business_one_page_pro_body_color', '#59595b' );
    
    $hps_title_font      = get_theme_mod( 'business_one_page_pro_hps_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $hps_title_fonts     = business_one_page_pro_get_fonts( $hps_title_font['font-family'], $hps_title_font['variant'] );
    $hps_title_font_size = get_theme_mod( 'business_one_page_pro_hps_title_font_size', '42' );
    $hps_title_line_ht   = get_theme_mod( 'business_one_page_pro_hps_title_line_height', '46' );
    $hps_title_color     = get_theme_mod( 'business_one_page_pro_hps_title_section', '#252626' );
    
    $hps_p_title_font      = get_theme_mod( 'business_one_page_pro_hps_portfolio_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $hps_p_title_fonts     = business_one_page_pro_get_fonts( $hps_p_title_font['font-family'], $hps_p_title_font['variant'] );
    $hps_p_title_font_size = get_theme_mod( 'business_one_page_pro_hps_portfolio_title_font_size', '32' );
    $hps_p_title_line_ht   = get_theme_mod( 'business_one_page_pro_hps_portfolio_title_line_height', '36' );
    
    $hps_t_title_font      = get_theme_mod( 'business_one_page_pro_hps_team_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $hps_t_title_fonts     = business_one_page_pro_get_fonts( $hps_t_title_font['font-family'], $hps_t_title_font['variant'] );
    $hps_t_title_font_size = get_theme_mod( 'business_one_page_pro_hps_team_title_font_size', '21' );
    $hps_t_title_line_ht   = get_theme_mod( 'business_one_page_pro_hps_team_title_line_height', '26' );
    $hps_t_title_color     = get_theme_mod( 'business_one_page_pro_hps_title_section', '#252626' );
    
    $blog_title_font      = get_theme_mod( 'business_one_page_pro_blog_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $blog_title_fonts     = business_one_page_pro_get_fonts( $blog_title_font['font-family'], $blog_title_font['variant'] );
    $blog_title_font_size = get_theme_mod( 'business_one_page_pro_blog_title_font_size', '25' );
    $blog_title_line_ht   = get_theme_mod( 'business_one_page_pro_blog_title_line_height', '30' );
    $blog_title_color     = get_theme_mod( 'business_one_page_pro_blog_title_color', '#252626' );
    
    $page_title_font      = get_theme_mod( 'business_one_page_pro_page_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $page_title_fonts     = business_one_page_pro_get_fonts( $page_title_font['font-family'], $page_title_font['variant'] );
    $page_title_font_size = get_theme_mod( 'business_one_page_pro_page_title_font_size', '28' );
    $page_title_line_ht   = get_theme_mod( 'business_one_page_pro_page_title_line_height', '32' );
    $page_title_color     = get_theme_mod( 'business_one_page_pro_page_title_color', '#252626' );
    
    $post_title_font      = get_theme_mod( 'business_one_page_pro_post_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $post_title_fonts     = business_one_page_pro_get_fonts( $post_title_font['font-family'], $post_title_font['variant'] );
    $post_title_font_size = get_theme_mod( 'business_one_page_pro_post_title_font_size', '25' );
    $post_title_line_ht   = get_theme_mod( 'business_one_page_pro_post_title_line_height', '32' );
    $post_title_color     = get_theme_mod( 'business_one_page_pro_post_title_color', '#252626' );
    
    $contact_title_font      = get_theme_mod( 'business_one_page_pro_contact_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $contact_title_fonts     = business_one_page_pro_get_fonts( $contact_title_font['font-family'], $contact_title_font['variant'] );
    $contact_title_font_size = get_theme_mod( 'business_one_page_pro_contact_title_font_size', '21' );
    $contact_title_line_ht   = get_theme_mod( 'business_one_page_pro_contact_title_line_height', '26' );
    $contact_title_color     = get_theme_mod( 'business_one_page_pro_contact_title_color', '#252626' );
    
    $testimonial_title_font      = get_theme_mod( 'business_one_page_pro_testimonial_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $testimonial_title_fonts     = business_one_page_pro_get_fonts( $testimonial_title_font['font-family'], $testimonial_title_font['variant'] );
    $testimonial_title_font_size = get_theme_mod( 'business_one_page_pro_testimonial_title_font_size', '17' );
    $testimonial_title_line_ht   = get_theme_mod( 'business_one_page_pro_testimonial_title_line_height', '21' );
    $testimonial_title_color     = get_theme_mod( 'business_one_page_pro_testimonial_title_color', '#252626' );
    
    $team_title_font      = get_theme_mod( 'business_one_page_pro_team_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $team_title_fonts     = business_one_page_pro_get_fonts( $team_title_font['font-family'], $team_title_font['variant'] );
    $team_title_font_size = get_theme_mod( 'business_one_page_pro_team_title_font_size', '21' );
    $team_title_line_ht   = get_theme_mod( 'business_one_page_pro_team_title_font_line_height', '24' );
    $team_title_color     = get_theme_mod( 'business_one_page_pro_team_title_font_color', '#252626' );
    
    $portfolio_title_font      = get_theme_mod( 'business_one_page_pro_portfolio_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $portfolio_title_fonts     = business_one_page_pro_get_fonts( $portfolio_title_font['font-family'], $portfolio_title_font['variant'] );
    $portfolio_title_font_size = get_theme_mod( 'business_one_page_pro_portfolio_title_font_size', '25' );
    $portfolio_title_line_ht   = get_theme_mod( 'business_one_page_pro_portfolio_title_line_height', '30' );
    
    $mcv_title_font      = get_theme_mod( 'business_one_page_pro_mcv_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $mcv_title_fonts     = business_one_page_pro_get_fonts( $mcv_title_font['font-family'], $mcv_title_font['variant'] );
    $mcv_title_font_size = get_theme_mod( 'business_one_page_pro_mcv_title_font_size', '32' );
    $mcv_title_line_ht   = get_theme_mod( 'business_one_page_pro_mcv_title_line_height', '36' );
    $mcv_title_color     = get_theme_mod( 'business_one_page_pro_mcv_title_color', '#252626' );
    
    $client_title_font      = get_theme_mod( 'business_one_page_pro_client_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $client_title_fonts     = business_one_page_pro_get_fonts( $client_title_font['font-family'], $client_title_font['variant'] );
    $client_title_font_size = get_theme_mod( 'business_one_page_pro_client_title_font_size', '32' );
    $client_title_line_ht   = get_theme_mod( 'business_one_page_pro_client_title_font_line_height', '36' );
    $client_title_color     = get_theme_mod( 'business_one_page_pro_client_title_font_color', '#252626' );
    
    $service_st_font      = get_theme_mod( 'business_one_page_pro_s_section_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $service_st_fonts     = business_one_page_pro_get_fonts( $service_st_font['font-family'], $service_st_font['variant'] );
    $service_st_font_size = get_theme_mod( 'business_one_page_pro_s_section_title_font_size', '32' );
    $service_st_line_ht   = get_theme_mod( 'business_one_page_pro_s_section_title_font_line_height', '36' );
    $service_st_color     = get_theme_mod( 'business_one_page_pro_s_section_title_font_color', '#252626' );
        
    $h1_font      = get_theme_mod( 'business_one_page_pro_h1_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h1_fonts     = business_one_page_pro_get_fonts( $h1_font['font-family'], $h1_font['variant'] );
    $h1_font_size = get_theme_mod( 'business_one_page_pro_h1_font_size', '42' );
    $h1_line_ht   = get_theme_mod( 'business_one_page_pro_h1_line_height', '46' );
    $h1_color     = get_theme_mod( 'business_one_page_pro_h1_color', '#252626' );
    
    $h2_font      = get_theme_mod( 'business_one_page_pro_h2_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h2_fonts     = business_one_page_pro_get_fonts( $h2_font['font-family'], $h2_font['variant'] );
    $h2_font_size = get_theme_mod( 'business_one_page_pro_h2_font_size', '32' );
    $h2_line_ht   = get_theme_mod( 'business_one_page_pro_h2_line_height', '36' );
    $h2_color     = get_theme_mod( 'business_one_page_pro_h2_color', '#252626' );
    
    $h3_font      = get_theme_mod( 'business_one_page_pro_h3_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h3_fonts     = business_one_page_pro_get_fonts( $h3_font['font-family'], $h3_font['variant'] );
    $h3_font_size = get_theme_mod( 'business_one_page_pro_h3_font_size', '25' );
    $h3_line_ht   = get_theme_mod( 'business_one_page_pro_h3_line_height', '29' );
    $h3_color     = get_theme_mod( 'business_one_page_pro_h3_color', '#252626' );
    
    $h4_font      = get_theme_mod( 'business_one_page_pro_h4_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h4_fonts     = business_one_page_pro_get_fonts( $h4_font['font-family'], $h4_font['variant'] );
    $h4_font_size = get_theme_mod( 'business_one_page_pro_h4_font_size', '23' );
    $h4_line_ht   = get_theme_mod( 'business_one_page_pro_h4_line_height', '27' );
    $h4_color     = get_theme_mod( 'business_one_page_pro_h4_color', '#252626' );
    
    $h5_font      = get_theme_mod( 'business_one_page_pro_h5_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h5_fonts     = business_one_page_pro_get_fonts( $h5_font['font-family'], $h5_font['variant'] );
    $h5_font_size = get_theme_mod( 'business_one_page_pro_h5_font_size', '21' );
    $h5_line_ht   = get_theme_mod( 'business_one_page_pro_h5_line_height', '25' );
    $h5_color     = get_theme_mod( 'business_one_page_pro_h5_color', '#252626' );
    
    $h6_font      = get_theme_mod( 'business_one_page_pro_h6_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $h6_fonts     = business_one_page_pro_get_fonts( $h6_font['font-family'], $h6_font['variant'] );
    $h6_font_size = get_theme_mod( 'business_one_page_pro_h6_font_size', '19' );
    $h6_line_ht   = get_theme_mod( 'business_one_page_pro_h6_line_height', '23' );
    $h6_color     = get_theme_mod( 'business_one_page_pro_h6_color', '#252626' );
    
    $widget_title_font      = get_theme_mod( 'business_one_page_pro_widget_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $widget_title_fonts     = business_one_page_pro_get_fonts( $widget_title_font['font-family'], $widget_title_font['variant'] );    
    $widget_title_font_size = get_theme_mod( 'business_one_page_pro_widget_title_font_size', '21' );
    $widget_title_line_ht   = get_theme_mod( 'business_one_page_pro_widget_title_line_height', '25' );
    $widget_ulli_font_size  = get_theme_mod( 'business_one_page_pro_widget_ulli_font_size', '17' );
    $widget_ulli_line_ht    = get_theme_mod( 'business_one_page_pro_widget_ulli_line_height', '24' );    
    $widget_title_color     = get_theme_mod( 'business_one_page_pro_widget_title_color', '#252626' );
    
    $widget_post_font       = get_theme_mod( 'business_one_page_pro_widget_post_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $widget_post_fonts      = business_one_page_pro_get_fonts( $widget_post_font['font-family'], $widget_post_font['variant'] );
    $widget_post_font_size  = get_theme_mod( 'business_one_page_pro_widget_post_font_size', '19' );
    $widget_post_line_ht    = get_theme_mod( 'business_one_page_pro_widget_post_line_height', '22' );
    $widget_post_color      = get_theme_mod( 'business_one_page_pro_widget_post_title_color', '#252626' );
    
    $color_scheme    = get_theme_mod( 'business_one_page_pro_color_scheme', '#f4b400' );
    $s_color_scheme  = get_theme_mod( 'business_one_page_pro_secondary_color_scheme', '#0B578E' );
    $footer_scheme   = get_theme_mod( 'business_one_page_pro_footer_color_scheme', '#05263E' );
    $bg_color        = get_theme_mod( 'business_one_page_pro_bg_color', '#FFFFFF' );
    $body_bg         = get_theme_mod( 'business_one_page_pro_body_bg', 'image' );
    $bg_image        = get_theme_mod( 'business_one_page_pro_bg_image' );
    $bg_pattern      = get_theme_mod( 'business_one_page_pro_bg_pattern', 'nobg' );
    $ed_auth_comment = get_theme_mod( 'business_one_page_pro_ed_auth_comments' );
    
    $rgb = business_one_page_pro_hex2rgb( business_one_page_pro_sanitize_hex_color( $s_color_scheme ) );

    $image = '';
    if( $body_bg == 'image' && $bg_image ){
        $image = $bg_image;    
    }elseif( $body_bg == 'pattern' && $bg_pattern != 'nobg' ){
        $image = get_template_directory_uri() . '/images/patterns/' . $bg_pattern . '.png';
    }

    echo "<style type='text/css' media='all'>"; ?>
    
    body{
    	font-size: <?php echo absint( $body_font_size ); ?>px;
    	line-height: <?php echo absint( $body_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    	font-family: <?php echo $body_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $body_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $body_fonts['style'] ); ?>;
        background: url(<?php echo esc_url( $image ); ?>) <?php echo business_one_page_pro_sanitize_hex_color( $bg_color ); ?>;
    }
    
    a {
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    a:hover,
    a:focus{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
        text-decoration: underline;
    }

    /*main heading of each section in home page*/
    #about .heading h1,
    #services .heading h1,
    #portfolio .heading h1,
    .our-team .heading h1,
    .blog-section .heading h1,
    #testimonial .heading h1,
    #contact .heading h1{
    	font-size: <?php echo absint( $hps_title_font_size ); ?>px;
    	line-height: <?php echo absint( $hps_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $hps_title_color ); ?>;
    	font-family: <?php echo $hps_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $hps_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $hps_title_fonts['style'] ); ?>;        
    }
    
    /*homepage portfolio title*/
    #portfolio .portfolio-col .img-holder .text .title{
    	font-size: <?php echo absint( $hps_p_title_font_size ); ?>px;
    	line-height: <?php echo absint( $hps_p_title_line_ht ); ?>px;
    	font-family: <?php echo $hps_p_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $hps_p_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $hps_p_title_fonts['style'] ); ?>;
    }

    /*home page our team title*/
    .our-team .team-holder .box .name{
    	font-size: <?php echo absint( $hps_t_title_font_size ); ?>px;
    	line-height: <?php echo absint( $hps_t_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $hps_t_title_color ); ?>;
    	font-family: <?php echo $hps_t_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $hps_t_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $hps_t_title_fonts['style'] ); ?>;  
    }

    /*home page blog section title style*/
    .blog-section .columns-3 .post .entry-header .entry-title {
        font-size: <?php echo absint( $blog_title_font_size ); ?>px;
    	line-height: <?php echo absint( $blog_title_line_ht ); ?>px;    	
    	font-family: <?php echo $blog_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $blog_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $blog_title_fonts['style'] ); ?>;  
    }

    .blog-section .columns-3 .post .entry-header .entry-title a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $blog_title_color ); ?>;
    }
    
    .blog-section .columns-3 .post .entry-header .entry-title a:hover,
    .blog-section .columns-3 .post .entry-header .entry-title a:focus{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .blog-section .columns-3 .post .entry-meta a:hover,
    .blog-section .columns-3 .post .entry-meta a:focus{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    /*page title style*/
    .page-header .page-title {
        font-size: <?php echo absint( $page_title_font_size ); ?>px;
    	line-height: <?php echo absint( $page_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $page_title_color ); ?>;
    	font-family: <?php echo $page_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $page_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $page_title_fonts['style'] ); ?>; 
    }
    
    .contact-section h2 {
        font-size: <?php echo absint( $contact_title_font_size ); ?>px;
    	line-height: <?php echo absint( $contact_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $contact_title_color ); ?>;
    	font-family: <?php echo $contact_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $contact_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $contact_title_fonts['style'] ); ?>;
    }

    .inner-page .testimonial-wrap .testimonial-holder .testimonial-title,
    .testimonial-slider .lightSlider .name {
        font-size: <?php echo absint( $testimonial_title_font_size ); ?>px;
    	line-height: <?php echo absint( $testimonial_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $testimonial_title_color ); ?>;
    	font-family: <?php echo $testimonial_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $testimonial_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $testimonial_title_fonts['style'] ); ?>;
    }

    .page-template-template-team .team-section .col .box .text-holder .name
    {
        font-size: <?php echo absint( $team_title_font_size ); ?>px;
    	line-height: <?php echo absint( $team_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $team_title_color ); ?>;
    	font-family: <?php echo $team_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $team_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $team_title_fonts['style'] ); ?>;
    }

    .inner-page .portfolio-section .portfolio-grid .portfolio-element .portfolio-hover h2 {
        font-size: <?php echo absint( $portfolio_title_font_size ); ?>px;
    	line-height: <?php echo absint( $portfolio_title_line_ht ); ?>px;
    	font-family: <?php echo $portfolio_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $portfolio_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $portfolio_title_fonts['style'] ); ?>;
    }

    .page-template-template-about .our-mission .title,
    .page-template-template-about .our-values .title{
        font-size: <?php echo absint( $mcv_title_font_size ); ?>px;
    	line-height: <?php echo absint( $mcv_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $mcv_title_color ); ?>;
    	font-family: <?php echo $mcv_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $mcv_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $mcv_title_fonts['style'] ); ?>;
    }

    .our-clients .title {
        font-size: <?php echo absint( $client_title_font_size ); ?>px;
    	line-height: <?php echo absint( $client_title_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $client_title_color ); ?>;
    	font-family: <?php echo $client_title_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $client_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $client_title_fonts['style'] ); ?>;
    }
    
    .page-template-template-services .our-features .title,
    .page-template-template-services .more-about-us .title{
        font-size: <?php echo absint( $service_st_font_size ); ?>px;
    	line-height: <?php echo absint( $service_st_line_ht ); ?>px;
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $service_st_color ); ?>;
    	font-family: <?php echo $service_st_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $service_st_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $service_st_fonts['style'] ); ?>;        
    }

    /* H1 content */
    .post .entry-content h1,
    .page .entry-content h1{
        font-family: <?php echo $h1_fonts['font']; ?>;
        font-size: <?php echo absint( $h1_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h1_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h1_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h1_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h1_color ); ?>;
    }
    
    /* H2 content */
    .post .entry-content h2,
    .page .entry-content h2{
        font-family: <?php echo $h2_fonts['font']; ?>;
        font-size: <?php echo absint( $h2_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h2_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h2_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h2_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h2_color ); ?>;
    }
    
    /* H3 content */
    .post .entry-content h3,
    .page .entry-content h3{
        font-family: <?php echo $h3_fonts['font']; ?>;
        font-size: <?php echo absint( $h3_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h3_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h3_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h3_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h3_color ); ?>;
    }
    
    /* H4 content */
    .post .entry-content h4,
    .page .entry-content h4{
        font-family: <?php echo $h4_fonts['font']; ?>;
        font-size: <?php echo absint( $h4_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h4_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h4_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h4_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h4_color ); ?>;
    }
    
    /* H5 content */
    .post .entry-content h5,
    .page .entry-content h5{
        font-family: <?php echo $h5_fonts['font']; ?>;
        font-size: <?php echo absint( $h5_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h5_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h5_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h5_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h5_color ); ?>;
    }
    
    /* H6 content */
    .post .entry-content h6,
    .page .entry-content h6{
        font-family: <?php echo $h6_fonts['font']; ?>;
        font-size: <?php echo absint( $h6_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $h6_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $h6_fonts['style'] ); ?>;
        line-height: <?php echo absint( $h6_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $h6_color ); ?>;
    }

    #primary .post .entry-content .rara_accordian .rara_accordian_title,
    #primary .page .entry-content .rara_accordian .rara_accordian_title{
    	background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    #primary .entry-content .rara_call_to_action_button {
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .content-area .post .entry-header .entry-meta a:hover,
    .content-area .post .entry-header .entry-meta a:focus {
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    /**Blog Archive */
    .blog .content-area .post .entry-header .entry-title,
    .search .content-area .post .entry-header .entry-title,
    .search .content-area .page .entry-header .entry-title {
        font-family: <?php echo $post_title_fonts['font']; ?>;
        font-size: <?php echo absint( $post_title_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $post_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $post_title_fonts['style'] ); ?>;
        line-height: <?php echo absint( $post_title_line_ht ); ?>px;
        
    }
    
    .blog .content-area .post .entry-header .entry-title a,
    .search .content-area .post .entry-header .entry-title a,
    .search .content-area .page .entry-header .entry-title a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $post_title_color ); ?>;
    }
    
    .blog .content-area .post .entry-header .entry-title a:hover,
    .blog .content-area .post .entry-header .entry-title a:focus,
    .search .content-area .post .entry-header .entry-title a:hover,
    .search .content-area .post .entry-header .entry-title a:focus,
    .search .content-area .page .entry-header .entry-title a:hover,
    .search .content-area .page .entry-header .entry-title a:focus{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .blog .content-area .post .entry-content .btn-readmore,
    .search .content-area .post .entry-content .btn-readmore,
    .search .content-area .page .entry-content .btn-readmore {
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    /** Widget s*/
    
    
    #secondary .widget .widget-title {
        font-family: <?php echo $widget_title_fonts['font']; ?>;
        font-size: <?php echo absint( $widget_title_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $widget_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $widget_title_fonts['style'] ); ?>;
        line-height: <?php echo absint( $widget_title_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $widget_title_color ); ?>;
    }
    
    #secondary .widget ul {
        font-size: <?php echo absint( $widget_ulli_font_size ); ?>px;
        line-height: <?php echo esc_attr( $widget_ulli_line_ht ); ?>px;
    }
    
    #secondary .widget ul li a:hover,
    #secondary .widget ul li a:focus{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-title,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-title,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-title,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-title,
    .footer-t .widget.widget_business_one_page_pro_popular_post .entry-header .entry-title,
    .footer-t .widget.widget_business_one_page_pro_recent_post .entry-header .entry-title,
    .footer-t .widget.widget_business_one_page_pro_category_post .entry-header .entry-title,
    .footer-t .widget.widget_business_one_page_pro_author_post .entry-header .entry-title{
        font-family: <?php echo $widget_post_fonts['font']; ?>;
        font-size: <?php echo absint( $widget_post_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $widget_post_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $widget_post_fonts['style'] ); ?>;
        line-height: <?php echo absint( $widget_post_line_ht ); ?>px;
    }
    
    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-title a,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-title a,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-title a,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-title a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $widget_post_color ); ?>;
    }
    
    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-title a:hover,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-title a:hover,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-title a:hover,
    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-title a:focus,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-title a:focus,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-title a:focus,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-title a:focus,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-title a:hover{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .author-block .author-title,
    #comments .comments-title,
    .comment-reply-title,
    .comment-form label{
    	color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    	font-family: <?php echo $body_fonts['font']; ?>;
        font-weight: <?php echo esc_attr( $body_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $body_fonts['style'] ); ?>;    
    }
    
    .author-block .text-holder .author-name{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;    
    }
    

    .footer-t .widget .widget-title {
        font-family: <?php echo $widget_title_fonts['font']; ?>;
        font-size: <?php echo absint( $widget_title_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $widget_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $widget_title_fonts['style'] ); ?>;
        line-height: <?php echo absint( $widget_title_line_ht ); ?>px;
    }
    
    .comment-form input[type="submit"]{
    	font-weight: 600;
        font-size: 16px;
        line-hight: 38px;
        font-family: <?php echo $body_fonts['font']; ?>;
    	background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .banner-text .text .btn-more,
    .promotional-block .btn-start,
    #portfolio .btn-holder a,
    .blog-section .btn-holder a,
    .wpcf7-form input[type="submit"],
    #load-posts a,
    #secondary .widget_calendar table a{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .comment-list .comment-metadata a:hover,
    .comment-list .comment-metadata a:focus{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    #secondary .widget.widget_business_one_page_pro_twitter_feeds_widget ul li a,
    #secondary .widget.widget_rss ul li a{color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;}

    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-meta a:hover,
    #secondary .widget.widget_business_one_page_pro_popular_post .entry-header .entry-meta a:focus,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-meta a:hover,
    #secondary .widget.widget_business_one_page_pro_recent_post .entry-header .entry-meta a:focus,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-meta a:focus,
    #secondary .widget.widget_business_one_page_pro_category_post .entry-header .entry-meta a:hover,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-meta a:hover,
    #secondary .widget.widget_business_one_page_pro_author_post .entry-header .entry-meta a:focus{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    #secondary .widget.widget_tag_cloud a:hover,
    #secondary .widget.widget_tag_cloud a:focus{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
        border-color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    #secondary .widget.widget_business_one_page_pro_cta_widget .text .btn-start{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .page-template-template-services .more-about-us .btn-more{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .post .entry-content table th, .page .entry-content table th,
    .post .entry-content table td, .page .entry-content table td{
        font-family: <?php echo $body_fonts['font']; ?>;
    }
    
    .widget_business_one_page_pro_cta_widget .style1 .widget-title,
    .widget_business_one_page_pro_cta_widget .style2 .widget-title{
        font-family: <?php echo $body_fonts['font']; ?>;
    }

    .tags-block a:hover,
    .tags-block a:focus{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .page-template-template-team .team-section .col .box .social-networks li a:hover,
    .page-template-template-team .team-section .col .box .social-networks li a:focus{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .testimonial-slider .lSSlideOuter .lSPager.lSpg > li.active a,
    .testimonial-slider .lSSlideOuter .lSPager.lSpg > li a:hover,
    .testimonial-slider .lSSlideOuter .lSPager.lSpg > li a:focus{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
        border-color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    #contact .social-networks li a:hover,
    #contact .social-networks li a:focus{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
        border-color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .contact-info-lists li a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .site-footer{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $footer_scheme ); ?>;
    }

    .main-navigation ul li a:hover,
    .main-navigation ul li:hover > a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .rara_toggle .rara_toggle_title{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .rara_toggle,
    #primary .post .entry-content .rara_accordian,
    #primary .page .entry-content .rara_accordian{
        border: 1px solid <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    #primary .entry-content .rara_tab_wrap .rara_tab_group .tab-title{
    border: 1px solid <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    #primary .entry-content .rara_tab_wrap .rara_tab_group .tab-title.active,
    #primary .entry-content .rara_tab_wrap .rara_tab_group .tab-title:hover,
    #primary .entry-content .rara_tab_wrap .rara_tab_group .tab-title:focus{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    .inner-page .portfolio-section .button-group .is-active{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
        border-color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .page-template-template-team .team-section .col .box .text-holder .designation,
    .our-team .team-holder .box .designation{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .our-team .team-holder .box .hover-state{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .contact-section .social-networks li a:hover,
    .contact-section .social-networks li a:focus{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
        border-color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .inner-page .portfolio-section .portfolio-grid .portfolio-element .portfolio-hover,
    #portfolio .portfolio-col .img-holder .text{
        <?php echo 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.8);'; ?>
    }

    button,
    input[type="button"],
    input[type="reset"],
    input[type="submit"]{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    button,
    input,
    select,
    textarea {
        font-size: <?php echo absint( $body_font_size ); ?>px;
        line-height: <?php echo absint( $body_line_ht ); ?>px;
        font-family: <?php echo $body_fonts['font']; ?>;
    }
    
    /* Secondary Theme Color */
    .top-header {
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }
    
    .top-menu ul ul{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }
    
    .pagination a:hover,
    .pagination a:focus,
    .pagination .current{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;
    }

    .error404 .error-holder h1{
        font-family: <?php echo $body_fonts['font']; ?>;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    }

    .error404 .error-holder .btn-prev-page{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }

    #crumbs a{color: <?php echo business_one_page_pro_sanitize_hex_color( $s_color_scheme ); ?>;}

    <?php if( $ed_auth_comment ){ ?>
    /* Author Comment Style */
    .comments-area .bypostauthor > .comment-body{
            border: 2px solid #ccc;
            border-radius: 5px;
            padding: 15px 15px 30px;
        }
    <?php } ?>
    
    <?php if( is_woocommerce_activated() ) { ?>
    /* Woo Commerce Style */
    .woocommerce span.onsale{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .woocommerce #respond input#submit:hover,
    .woocommerce a.button:hover,
    .woocommerce button.button:hover,
    .woocommerce input.button:hover{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .woocommerce .widget_price_filter .ui-slider .ui-slider-range,
    .woocommerce .widget_price_filter .ui-slider .ui-slider-handle{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .woocommerce nav.woocommerce-pagination ul li a:hover,
    .woocommerce nav.woocommerce-pagination ul li a:focus,
    .woocommerce nav.woocommerce-pagination ul li span.current{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .woocommerce #respond input#submit.alt,
    .woocommerce a.button.alt,
    .woocommerce button.button.alt,
    .woocommerce input.button.alt{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
    }
    
    .woocommerce #respond input#submit.alt:hover,
    .woocommerce a.button.alt:hover,
    .woocommerce button.button.alt:hover,
    .woocommerce input.button.alt:hover{
        background: <?php echo business_one_page_pro_sanitize_hex_color( $color_scheme ); ?>;
        opacity: 0.8;
    }
    
    .woocommerce ul.products li.product .price{
	   color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    }
    
    .woocommerce div.product .product_title{
	   font-family: <?php echo $widget_title_fonts['font']; ?>;
        font-size: <?php echo absint( $widget_title_font_size ); ?>px;
        font-weight: <?php echo esc_attr( $widget_title_fonts['weight'] ); ?>;
        font-style: <?php echo esc_attr( $widget_title_fonts['style'] ); ?>;
        line-height: <?php echo absint( $widget_title_line_ht ); ?>px;
        color: <?php echo business_one_page_pro_sanitize_hex_color( $widget_title_color ); ?>;
       
    }
    
    .woocommerce div.product .woocommerce-tabs ul.tabs li a{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    }
    
    .related.products h2{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
        font-family: <?php echo $body_fonts['font']; ?>;
    }
    
    .woocommerce div.product .woocommerce-tabs .panel h2{
        font-family: <?php echo $body_fonts['font']; ?>;
    }

    .woocommerce ul.products li.product h3{
        color: <?php echo business_one_page_pro_sanitize_hex_color( $body_color ); ?>;
    }

    
    <?php } ?>

    <?php echo "</style>";  
}

/**
 * Function for sanitizing Hex color 
 */
function business_one_page_pro_sanitize_hex_color( $color ){
	if ( '' === $color )
		return '';

    // 3 or 6 hex digits, or the empty string.
	if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) )
		return $color;
}