<?php

return array(

  'title-tag'          => CS()->common()->properTitle(),
  'powered-by-themeco' => __( 'Powered by Themeco', 'cornerstone' ),

  // Messaging
  'welcome-app'       => __( '<strong>Howdy!</strong> What would you like to launch?', 'cornerstone' ),
  'save'              => __( 'Save', 'cornerstone' ),
  'loading'           => __( 'Loading&hellip;', 'cornerstone' ),
  'unauthorized'      => __( 'You don&apos;t have permission to do that.', 'cornerstone' ),
  'exit-to-dashboard' => __( 'Exit to Dashboard', 'cornerstone' ),
  'unsaved-warning'   => __( 'You have unsaved changes that will be lost if you continue. Are you sure you wish to leave?', 'cornerstone' ),

  // General Purpose
  'copy-of'    => __( 'Copy of {{title}}', 'cornerstone' ),
  'copy-of-numeric'    => __( '{{title}} ({{index}})', 'cornerstone' ),
  'new-at-index' => __( '{{item}} {{index}}', 'cornerstone'),
  'search' => __( 'Search', 'cornerstone' ),

  // Preview Sizer
  'preview-sizer-abbr-xl' => __( 'XL', 'cornerstone' ),
  'preview-sizer-abbr-lg' => __( 'LG', 'cornerstone' ),
  'preview-sizer-abbr-md' => __( 'MD', 'cornerstone' ),
  'preview-sizer-abbr-sm' => __( 'SM', 'cornerstone' ),
  'preview-sizer-abbr-xs' => __( 'XS', 'cornerstone' ),
  'preview-sizer-desc-xl'  => __( '1200px &amp; Up', 'cornerstone' ),
  'preview-sizer-desc-lg'  => __( '980px-1199px', 'cornerstone' ),
  'preview-sizer-desc-md'  => __( '768px-979px', 'cornerstone' ),
  'preview-sizer-desc-sm'  => __( '481px-767px', 'cornerstone' ),
  'preview-sizer-desc-xs'  => __( '480px &amp; Smaller', 'cornerstone' ),

  // Titles
  'home.title'      => __( 'Home', 'cornerstone' ),
  'options.title'   => __( 'Options', 'cornerstone' ),
  'headers.title'   => __( 'Headers', 'cornerstone' ),
  'footers.title'   => __( 'Footers', 'cornerstone' ),
  'builder.title'   => __( 'Content', 'cornerstone' ),
  'fonts.title'     => __( 'Fonts', 'cornerstone' ),
  'templates.title' => __( 'Templates', 'cornerstone' ),
  'layout.title'    => __( 'Layout', 'cornerstone' ),
  'inspector.title' => __( 'Inspector', 'cornerstone' ),

  // Inspector
  'inspector.na-title' => __( 'Nothing Selected', 'cornerstone' ),
  'inspector.search'   => __( 'Search Inspector.', 'cornerstone' ),
  'inspector.apply-preset-warning' => __( 'Applying a preset will change all element properties. Any changes you&apos;ve made will be overwritten. Would you like to proceed?', 'cornerstone' ),

  // Controls
  'controls-previous-missing'   => __( 'Previous Value Unavailable', 'cornerstone' ),
  'controls-font-family-select' => __( '{{family}} ({{source}})', 'cornerstone' ),

  // Notifications
  'notification-notice'  => __( 'Hey!', 'cornerstone' ),
  'notification-success' => __( 'Awesome!', 'cornerstone' ),
  'notification-error'   => __( 'Uh oh!', 'cornerstone' ),

  // Assignments
  'assignments.global'               => __( 'Global', 'cornerstone' ),
  'assignments.unassigned'           => __( 'Unassigned', 'cornerstone' ),
  'assignments.tagged'               => __( '{{tag}}: {{title}}', 'cornerstone' ),
  'assignments.multiple-assignments' => __( 'Multiple Assignments', 'cornerstone' ),

  // Elements
  'elements-confirm-delete' => __( 'Are you sure you want to delete this element? This can not be undone.', 'cornerstone' ),

  // Confirm
  'confirm-yep'  => __( 'Yes, Proceed', 'cornerstone' ),
  'confirm-nope' => __( 'No, Go Back', 'cornerstone' ),
  'confirm-back' => __( 'Back', 'cornerstone' ),


  // Options
  'options.launch-headers' => __( 'Launch Header Builder', 'cornerstone' ),
  'options.launch-footers' => __( 'Launch Footer Builder', 'cornerstone' ),
  'options.confirm-header-switch-back' => __( 'Are you sure you wish to switch back to Original Headers? This will unassign remove your global Pro Header.', 'cornerstone' ),
  'options.confirm-footer-switch-back' => __( 'Are you sure you wish to switch back to Original Footers? This will unassign remove your global Pro Footer.', 'cornerstone' ),

  // Templates
  'templates.welcome' => __( 'Manage all of your fonts and colors from one central location!', 'cornerstone' ),
  'templates.blank-welcome'   => __( 'Begin with a blank slate.', 'cornerstone'),

  // Fonts
  'fonts.new-title' => __( 'Font {{index}}', 'cornerstone' ),

  // Colors
  'colors.new-title'     => __( 'Color {{index}}', 'cornerstone' ),
  'colors.empty-message' => __( 'Click "Add New" to create a color selection.', 'cornerstone' ),

  // Font Weights
  'font-weight.100'       => __( '100 &ndash; Ultra Light', 'cornerstone' ),
  'font-weight.100italic' => __( '100 &ndash; Ultra Light (Italic)', 'cornerstone' ),
  'font-weight.200'       => __( '200 &ndash; Light', 'cornerstone' ),
  'font-weight.200italic' => __( '200 &ndash; Light (Italic)', 'cornerstone' ),
  'font-weight.300'       => __( '300 &ndash; Book', 'cornerstone' ),
  'font-weight.300italic' => __( '300 &ndash; Book (Italic)', 'cornerstone' ),
  'font-weight.400'       => __( '400 &ndash; Regular', 'cornerstone' ),
  'font-weight.400italic' => __( '400 &ndash; Regular (Italic)', 'cornerstone' ),
  'font-weight.500'       => __( '500 &ndash; Medium', 'cornerstone' ),
  'font-weight.500italic' => __( '500 &ndash; Medium (Italic)', 'cornerstone' ),
  'font-weight.600'       => __( '600 &ndash; Semi-Bold', 'cornerstone' ),
  'font-weight.600italic' => __( '600 &ndash; Semi-Bold (Italic)', 'cornerstone' ),
  'font-weight.700'       => __( '700 &ndash; Bold', 'cornerstone' ),
  'font-weight.700italic' => __( '700 &ndash; Bold (Italic)', 'cornerstone' ),
  'font-weight.800'       => __( '800 &ndash; Extra Bold', 'cornerstone' ),
  'font-weight.800italic' => __( '800 &ndash; Extra Bold (Italic)', 'cornerstone' ),
  'font-weight.900'       => __( '900 &ndash; Ultra Bold', 'cornerstone' ),
  'font-weight.900italic' => __( '900 &ndash; Ultra Bold (Italic)', 'cornerstone' ),

  // Choices
  'choices.menu-named'    => __('Menu: %s', 'cornerstone'),
  'choices.menu-location' => __('Location: %s', 'cornerstone'),

);
